<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions.
*/
require ("./functions.php");

$ref = $_GET['ref'];
$go = $_GET['go'];

$start_time = micro_time(0);

/*
 * Add a channel
 */
if ($go == 'addchannel') {

	$chan_name = mysql_real_escape_string(trim($_POST['chan_name']));
	$chan_desc = mysql_real_escape_string(trim($_POST['chan_desc']));

	if (strlen($chan_name) > 50) {
			bodyHeader('error', $version_num);
			bodyNavigation('error');
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>The channel name you specified exceeds the maximum allowed characters of 50.</p>' .
					'<p>Please go back and try again.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
	}
	if (strlen($chan_desc) > 250) {
			bodyHeader('error', $version_num);
			bodyNavigation('error');
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>The channel name you specified exceeds the maximum allowed characters of 250.</p>' .
					'<p>Please go back and try again.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
	}

	if (empty($chan_name)) {
			bodyHeader('error', $version_num);
			bodyNavigation('error');
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>You must enter a channel name.</p>' .
					'<p>Please go back and try again.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
	}

	mysql_query("INSERT INTO " . $db_table_prefix . "channels
		SET
		chan_name='$chan_name',
		chan_desc='$chan_desc'
	")
	or die(mysql_error());
	$_SESSION['changesuccess'] = "The channel, " . stripslashes(trim($_POST['chan_name'])) . ", has been added successfully.";

/*
 * Delete a channel
 */
} elseif ($go == 'dropchannel') {

	$channel_id = mysql_real_escape_string($_GET['id']);

	if (empty($channel_id)) {
		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>No channel id was specified for deletion.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	}

	mysql_query("DELETE FROM " . $db_table_prefix . "channels WHERE id = '$channel_id'")
	or die(mysql_error());
	$_SESSION['changesuccess'] = "Your channel has been deleted successfully.";

/*
 * Change the admin username and password
 */
} elseif ($go == 'userpass') {

	$user = mysql_real_escape_string($_POST['user']);
	$password1 = mysql_real_escape_string($_POST['password1']);
	$password2 = mysql_real_escape_string($_POST['password2']);

	if ((empty($user)) || (empty($password1)) || (empty($password2))) {
			
			bodyHeader('error', $version_num);
			bodyNavigation('error');
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>Please fill out all fields.</p>' .
					'<ul>' .
						'<li>Username</li>' .
						'<li>Password</li>' .
						'<li>Password Confirmation</li>' .
					'</ul>' .
					'<p>Please go back and try again.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
	}

	if (!empty($user) && !empty($password1) && !empty($password2)) {
		if ($password1 != $password2) {
			
			bodyHeader('error', $version_num);
			bodyNavigation('error');
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>Your password and password confirmation do not match.</p>' .
					'<p>Please go back and try again.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
		}

		// Verify that the password is at least 6 characters long.
		if (strlen($password1) < 6) {
			
			bodyHeader('error', $version_num);
			bodyNavigation('error');
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>Your password should be at least 6 characters in length.</p>' .
					'<p>Please go back and try again.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
		}

		$password_hash = sha1($password1);
		mysql_query("UPDATE " . $db_table_prefix . "users SET
		username = '$user',
		password = '$password_hash'
		")
		or die(mysql_error());
		$_SESSION['changesuccess'] = "Your username/password has been changed successfully.";
	} else {
		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>Unable to change username or password. Please enter all fields.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	}

/*
 * Change any of the configuration settings.
 */
} elseif ($go == 'changesettings') {

$email = $_POST['email'];
$email_confirm = $_POST['email_confirm'];
$emailnotice = $_POST['emailnotice'];
$emailalert = $_POST['emailalert'];
$emailalert_num = $_POST['emailalert_num'];
$clickmax = $_POST['clickmax'];
$clickmaxtime = $_POST['clickmaxtime'];
$gmtdifference = $_POST['timezone'];
$ip_db_check = $_POST['ip_db_check'];
$version_num = $_POST['version_num'];
$disable_all_ads = $_POST['disable_all_ads'];

/*
 * Go through each of the posted banned ips
 * and turn them into an valid array.
 */
$bannedips = trim($_POST['bannedips']);
$bannedips = preg_split('/[\\s]+/', $bannedips);
$bannedstring = '';
foreach($bannedips as $i => $ip) {
	if ($i != 0) {
		$bannedstring .= ",\n";
	}
	/*
	 * Make sure that each of the IP validates
	 * as either an IP address or range.
	 */
	if (!valid_ip_range($ip)) {
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p><span class="loginMessage">' . $ip . '</span> is not a valid IP address/range.</p>' .
				'<p>Please verify that the following conditions are met.</p>' .
				'<ul>' .
					'<li>Only one IP address per line.</li>' .
					'<li>IP can\'t start with a dot. (Ex: .157)</li>' .
					'<li>No more than 4 parts to an IP. (Ex: 24.56.208.13.42 is NOT a valid IP).</li>' .
					'<li>No part of an IP can be above \'255\'.</li>' .
					'<li>No part of an IP can be below \'1\'.</li>' .
					'<li>The only allowed characters are numbers (0-9) and periods (.).</li>' .
				'</ul>' .
				'<p>Please check the format and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	} else {
		$bannedstring .= "\"$ip\"";
	}
}

/*
 * Make sure that the user entered an email address.
 */
if (empty($email)) {
	bodyHeader('error', $version_num);
	bodyNavigation('error');
	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>Please enter an email address.</p>' .
			'<p>Please go back and try again.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();
}

/*
 * Make sure that the two email addresses match.
 */
if ($email != $email_confirm) {
	bodyHeader('error', $version_num);
	bodyNavigation('error');
	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>The email address and confirmation email address must match.</p>' .
			'<p>Please go back and try again.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();
}

/*
 * Make sure that the email address is valid.
 */
if (!is_valid_email("$email")) {
	bodyHeader('error', $version_num);
	bodyNavigation('error');
	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>The email address you entered is not a valid format.</p>' .
			'<p>Please go back and try again.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();
}

// Make sure that clickmax, clickmaxtime, and emailalert_num are numerical
if ((!empty($clickmax) && !is_numeric($clickmax)) || (!empty($clickmaxtime) && !is_numeric($clickmaxtime)) || (!empty($emailalert_num) && !is_numeric($emailalert_num))) {
	bodyHeader('error', $version_num);
	bodyNavigation('error');
	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>There is an invalid entry for one or more of the settings. The maximum click values and email alert number must be numeric.</p>' .
			'<p>Please go back and try again.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();
}

if (!isset($gmt_dif) || empty($gmt_dif)){
	$gmt_dif = 0;
}
if (empty($clickmax)) $clickmax = 99;
if (empty($clickmaxtime)) $clickmaxtime = 1;
if (empty($emailalert_num)) $emailalert_num = 5;

/*
 * Begin adding variables to config_settings.php
 */
$open_file = fopen("../config_settings.php", "w");

/*
 * If the script can not open the file,
 * produce an error.
 */
if (!$open_file) {
	bodyHeader('error', $version_num);
	bodyNavigation('error');
	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>The file, config_settings.php, was unable to be opened. Verify that permissions are set to 666.</p>' .
			'<p>Please go back and try again.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();
}

/*
 * Declare the contents of the file
 */
$file_contents = <<<EOD
<?php
/*
 * You can change these on the Settings page inside your Administration panel.
 */

\$email = "$email";

\$email_notice = $emailnotice;

\$email_alert = $emailalert;

\$emailalert_num = $emailalert_num;

\$clickmax = $clickmax;

\$clickmaxtime = $clickmaxtime * 3600;

\$gmt_dif = "$gmtdifference";

\$timestamp = time() + 60*60*(\$gmt_dif);

\$ip_db_check = $ip_db_check;

\$ip_range_ban_list = array(
$bannedstring
);

\$disable_all_ads = $disable_all_ads;

\$version_num = '$version_num';

?>
EOD;

fwrite($open_file, "$file_contents");
fclose($open_file);

/*
 * End of writing config_settings.php file.
 */

$_SESSION['changesuccess'] = "You have successfully updated your script settings.";

/*
 * Delete all logs from the database tables
 */
} elseif ($go == 'drop_all') {

	mysql_query("TRUNCATE " . $db_table_prefix . "adcheck_logs")
		or die(mysql_error());
	
	mysql_query("TRUNCATE " . $db_table_prefix . "blocklogs")
		or die(mysql_error());
	
	mysql_query("TRUNCATE " . $db_table_prefix . "logfiles")
		or die(mysql_error());

	$_SESSION['changesuccess'] = "You have successfully deleted all of your logs.";

/*
 * Delete a single IP from the blocked logs
 */
} elseif ($go == 'dropyourself_block') {

	$ip_delete = mysql_real_escape_string($_POST['ip_delete']);

	/*
	 * Make sure the user actually posted an IP address.
	 */
	if (empty($ip_delete)) {
		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>Please enter an IP address to delete.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	/*
	 * Make sure it is a valid IP address.
	 */
	} elseif (!valid_ip($ip_delete)) {
		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>Please enter a valid IP address to delete.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	}

	/*
	 * Go ahead and delete it from the blocked logs.
	 */
	mysql_query("DELETE FROM " . $db_table_prefix . "blocklogs WHERE visitor_ip = '$ip_delete'")
	or die(mysql_error());
	$num_rows = number_format(mysql_affected_rows());
	mysql_query("OPTIMIZE TABLE " . $db_table_prefix . "blocklogs");

	$_SESSION['changesuccess'] = "You have successfully deleted $num_rows instances of $ip_delete from your block logs.";

/*
 * Delete a single IP from the click logs
 */
} elseif ($go == 'dropyourself_all') {

	$ip_delete = mysql_real_escape_string($_POST['ip_delete']);

	/*
	 * Make sure the user actually posted an IP address.
	 */
	if (empty($ip_delete)) {
		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>Please enter an IP address to delete.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	/*
	 * Make sure it is a valid IP address.
	 */
	} elseif (!valid_ip($ip_delete)) {
		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>Please enter a valid IP address to delete.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	}

	/*
	 * Go ahead and delete it from the blocked logs.
	 */
	mysql_query("DELETE FROM " . $db_table_prefix . "logfiles WHERE visitor_ip = '$ip_delete'")
	or die(mysql_error());
	$num_rows = number_format(mysql_affected_rows());
	mysql_query("OPTIMIZE TABLE " . $db_table_prefix . "logfiles");
	
	$_SESSION['changesuccess'] = "You have successfully deleted $num_rows instances of $ip_delete from your click logs.";

} elseif ($go == 'drop_click') {

	$click_id = mysql_real_escape_string($_GET['click_id']);

	/*
	 * Make sure the user actually posted an IP address.
	 */
	if (empty($click_id) || !is_numeric($click_id)) {
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>A click ID was not specified.</p>' .
				'<p>Please go back and try again.</p>' .
			'</div>';
		bodyFooter('error', $start_time);
		exit();
	}

	/*
	 * Go ahead and delete it from the blocked logs.
	 */
	mysql_query("DELETE FROM " . $db_table_prefix . "logfiles WHERE id = '$click_id'")
	or die(mysql_error());
	$num_rows = number_format(mysql_affected_rows());
	mysql_query("OPTIMIZE TABLE " . $db_table_prefix . "logfiles");

	$ref = './all_clicks.php';

/*
 * If no action was specified or the action is invalid,
 * produce an error.
 */
} else {

		
		bodyHeader('error', $version_num);
		bodyNavigation('error');
		echo '<div id="main-copy">' .
				'<h1>Error!</h1>' .
				'<p>No action was specified.</p>' .
				'<p>Please go back to the Settings page and try again.</p>' .
				'</div>';
		bodyFooter('error', $start_time);
		exit();

}

/*
 * Send the user back to the Settings page with their SESSION message.
 */
header("Location: " . $ref);
exit();
?>